# TP 16 correction (exemples de manipulations avec Numpy) : Manipulation d'images
# BCPST1B 2025-2026
# Lycée Hoche, Versailles
# L.-C. LEFÈVRE

#%% modules et fonctions globales

import numpy as np
import matplotlib.pyplot as plt
import PIL

def afficher(X):
    plt.imshow(X)
    plt.show()

def taille(X):
    (n, p, _) = X.shape
    return (n, p)

def image_vierge(n, p):
    Y = np.zeros((n, p, 3), dtype=np.uint8)
    return Y

def copie(X):
    Y = X.copy()
    return Y

#%% paramètres utilisateurs globaux

choix = "Photos/Hoche.jpg"
with PIL.Image.open(choix) as f:
    g = f.convert("RGB")
    image = np.asarray(g)
    print("Image choisie :", choix)
    print("Mode (L : niveaux de gris, RGB : couleurs) :", g.mode)
    print("Dimensions du tableau :", image.shape)
    print("Type des données :", image.dtype)
    afficher(image)

#%%

def miroir(X):
    Y = X.copy()
    # syntaxe des tranches comme nous avons vu : renverse le deuxième axe
    return Y[:, ::-1, :]

def negatif(X):
    Y = X.copy()
    # c'est aussi court que ça ! merci Numpy !
    return 255 - Y

def contraste(X):
    # parlez-vous Numpy ?
    Y = np.zeros_like(X)
    Y[X < 96] = X[X < 96] / 4
    Y[(96 <= X) & (X < 160)] = 24 + 13/4 * (X[(96 <= X) & (X < 160)] - 96)
    Y[160 <= X] = 232 + 1/4 * (X[160 <= X] - 160)
    return Y

def flou(X):
    Y = np.zeros_like(X)
    # évite les débordements des uint8, je ne sais pas faire sans
    X = X.astype(np.float64)
    # une seule formule avec des tranches remplace la double boucle avec les i-1, i+1, etc
    Y[1:-1, 1:-1] = (3*X[1:-1, 1:-1] + 2*X[:-2, 1:-1] + 2*X[1:-1, :-2] + 2*X[2:, 1:-1] + 2*X[1:-1, 2:] + 1*X[2:, 2:] + 1*X[:-2, 2:] + 1*X[2:, :-2] + 1*X[:-2, :-2]) / 15
    # c'était suffisant ; mais on traite aussi les bords et les coins :
    Y[1:-1, 0] = (3*X[1:-1, 0] + 2*X[:-2, 0] + 2*X[1:-1, 1] + 2*X[2:, 0] + 1*X[:-2, 1] + 1*X[2:, 1]) / 11
    Y[1:-1, -1] = (3*X[1:-1, -1] + 2*X[:-2, -1] + 2*X[1:-1, -2] + 2*X[2:, -1] + 1*X[:-2, -2] + 1*X[2:, -2]) / 11
    Y[0, 1:-1] = (3*X[0, 1:-1] + 2*X[0, :-2] + 2*X[0, 2:] + 2*X[1, 1:-1] + 1*X[1, :-2] + 1*X[1, 2:]) / 11
    Y[-1, 1:-1] = (3*X[-1, 1:-1] + 2*X[-1, :-2] + 2*X[-1, 2:] + 2*X[-2, 1:-1] + 1*X[-2, :-2] + 1*X[-2, 2:]) / 11
    Y[0, 0] = (3*X[0, 0] + 2*X[1, 0] + 2*X[0, 1] + 1*X[1, 1]) / 8
    Y[0, -1] = (3*X[0, -1] + 2*X[1, -1] + 2*X[0, -2] + 1*X[1, -2]) / 8
    Y[-1, 0] = (3*X[-1, 0] + 2*X[-2, 0] + 2*X[-1, 1] + 1*X[-2, 1]) / 8
    Y[-1, -1] = (3*X[-1, -1] + 2*X[-2, -1] + 2*X[-1, -2] + 1*X[-2, -2]) / 8
    return Y

#%%
# test : flou hyper puissant et presque instantané : merci Numpy !
Y = image
for _ in range(100):
    Y = flou(Y)
afficher(Y)
