# TP 16 (version niveaux de gris) correction : Manipulation d'images
# BCPST1B 2025-2026
# Lycée Hoche, Versailles
# L.-C. LEFÈVRE

#%% modules et fonctions globales
# exécuter une fois pour toute, regarder, ne pas toucher

import numpy as np
import matplotlib.pyplot as plt
import PIL

def afficher(X):
    # cmap nécessaire pour interpréter les niveaux de gris
    plt.imshow(X, cmap="gray")
    plt.show()

# affiche les images X et Y l'une au-dessus de l'autre
def afficher2(X, Y):
    plt.subplot(2, 1, 1)
    plt.imshow(X, cmap="gray")
    plt.subplot(2, 1, 2)
    plt.imshow(Y, cmap="gray")
    plt.show()

def taille(X):
    (n, p) = X.shape
    return (n, p)

def image_vierge(n, p):
    Y = np.zeros((n, p), dtype=np.uint8)
    return Y

def copie(X):
    Y = X.copy()
    return Y

# sauvegarde l'image X dans le fichier nommé nom
# par exemple sauvegarde(X, "nom.jpg")
def sauvegarde(X, nom):
    # f représente une image PIL
    f = PIL.Image.fromarray(X, mode="L")
    f.save(nom)

#%% paramètres utilisateurs globaux
# exécuter après chaque changement d'image

# choisir son image dans le dossier Photos
choix = "Photos/Hoche.jpg"

# chargement de l'image et test de l'affichage
with PIL.Image.open(choix) as f:
    # f représente un fichier image PIL
    # g est l'image PIL convertie en niveaux de gris
    g = f.convert("L")
    # image est un tableau numpy obtenu à partir de g
    image = np.asarray(g)
    # tests
    print("Image choisie :", choix)
    print("Mode (L : niveaux de gris, RGB : couleurs) :", g.mode)
    print("Dimensions du tableau :", image.shape)
    print("Type des données :", image.dtype)
    afficher(image)

# C'est partiiiiii

#%% exercice 1

def miroir(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            Y[i, j] = X[i, p-1-j]
    return Y

# test
Y = miroir(image)
#afficher(Y)
afficher2(image, Y)
#sauvegarde(Y, "test_miroir.jpg")

#%% exercice 2

def pivote(X):
    (n, p) = taille(X)
    Y = image_vierge(p, n)
    for i in range(p):
        for j in range(n):
            Y[i, j] = X[n-1-j, i]
    return Y

# test
Y = pivote(image)
afficher(Y)

#%% exercice 3

def eclaircit(X, b):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            if X[i, j] <= 255 - b:
                Y[i, j] = X[i, j] + b
            else:
                Y[i, j] = 255
    return Y

# test
Y = eclaircit(image, 80)
afficher2(image, Y)

#%% exercice 4

def seuillage(X, s):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            if X[i, j] <= s:
                Y[i, j] = 0
            else:
                Y[i, j] = 255
    return Y

# test
Y = seuillage(image, 95)
afficher(Y)

#%%
# autre test
choix = "Photos/Trianon.jpg"
with PIL.Image.open(choix) as f:
    g = f.convert("L")
    image_Trianon = np.asarray(g)

Y = seuillage(image_Trianon, 115)
afficher(Y)

#%% exercice 5

def contraste(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            if X[i, j] < 96:
                Y[i, j] =  1/4 * X[i, j]
            elif X[i, j] < 160:
                Y[i, j] = 24 + 13/4 * (X[i, j] - 96)
            else:
                Y[i, j] = 232 + 1/4 * (X[i, j] - 160)
    return Y

# test
Y = contraste(image)
afficher2(image, Y)

#%% exercice 6

def negatif(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            Y[i, j] = 255 -  X[i, j]
    return Y

# test
Y = negatif(image)
afficher(Y)

#%% exercice 7

def flou(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(1, n-1):
        for j in range(1, p-1):
            Y[i, j] = (3.0*X[i, j] + 2.0*X[i-1, j] + 2.0*X[i, j-1] + 2.0*X[i+1, j] + 2.0*X[i, j+1] + 1.0*X[i-1, j-1] + 1.0*X[i-1, j+1] + 1.0*X[i+1, j-1] + 1.0*X[i+1, j+1]) / 15
    # c'est suffisant ! mais
    # bonus : prise en compte des bords
    # bord gauche
    for i in range(1, n-1):
        Y[i, 0] = (3.0*Y[i, 0] + 2.0*Y[i-1, 0] + 2.0*Y[i+1, 0] + 2.0*Y[i+1, 1] + 1.0*Y[i-1, 1] + 1.0*Y[i+1, 1]) / 11
    # bord droit
    for i in range(1, n-1):
        Y[i, p-1] = (3.0*Y[i, p-1] + 2.0*Y[i-1, p-1] + 2.0*Y[i+1, p-1] + 2.0*Y[i+1, p-2] + 1.0*Y[i-1, p-2] + 1.0*Y[i+1, p-2]) / 11
    # bord haut
    for j in range(1, p-1):
        Y[0, j] = (3.0*Y[0, j] + 2.0*Y[0, j-1] + 2.0*Y[0, j+1] + 2.0*Y[1, j] + 1.0*Y[1, j-1] + 1.0*Y[1, j+1]) / 11
    # bord bas
    for j in range(1, p-1):
        Y[n-1, j] = (3.0*Y[n-1, j] + 2.0*Y[n-1, j-1] + 2.0*Y[n-1, j+1] + 2.0*Y[n-2, j] + 1.0*Y[n-2, j-1] + 1.0*Y[n-2, j+1]) / 11
    # coin haut gauche
    Y[0, 0] = (3.0*Y[0, 0] + 2.0*Y[1, 0] + 2.0*Y[0, 1] + 1.0*Y[1, 1]) / 8
    # coin haut droit
    Y[0, p-1] = (3.0*Y[0, p-1] + 2.0*Y[1, p-1] + 2.0*Y[0, p-2] + 1.0*Y[1, p-2]) / 8
    # coin bas gauche
    Y[n-1, 0] = (3.0*Y[n-1, 0] + 2.0*Y[n-2, 0] + 2.0*Y[n-1, 1] + 1.0*Y[n-2, 1]) / 8
    # coin bas droit
    Y[n-1, p-1] = (3.0*Y[n-1, p-1] + 2.0*Y[n-2, p-1] + 2.0*Y[n-1, p-2] + 1.0*Y[n-2, p-2]) / 8
    return Y

# test
Y = flou(image)
afficher2(image, Y)

#%%
# test de flou plus fort (attention au temps d'exécution)

Y = image
for _ in range(10):
    Y = flou(Y)
afficher(Y)

#%% exercice 8

def contours(X, s):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(1, n-1):
        for j in range(1, p-1):
            t = 8.0*X[i, j] - 1.0*X[i-1, j] - 1.0*X[i, j-1] - 1.0*X[i+1, j] - 1.0*X[i, j+1] - 1.0*X[i-1, j-1] - 1.0*X[i-1, j+1] - 1.0*X[i+1, j-1] - 1.0*X[i+1, j+1]
            if abs(t) > s:
                Y[i, j] = 0
            else:
                Y[i, j] = 255
    return Y

# test (essayer plusieurs fois en réglant le seuil)
Y = contours(image, 60)
afficher(Y)

#%%
# autre test
choix = "Photos/Marseille.jpg"
with PIL.Image.open(choix) as f:
    g = f.convert("L")
    image_Marseille = np.asarray(g)

Y = contours(image_Marseille, 100)
afficher(Y)

#%%
# autre test
choix = "Photos/surf.jpg"
with PIL.Image.open(choix) as f:
    g = f.convert("L")
    image_surf = np.asarray(g)

Y = contours(image_surf, 50)
afficher(Y)

#%%
# la suite est en couleurs !
