# TP 16 (fichier à compléter, version niveaux de gris) : Manipulation d'images
# BCPST1B 2025-2026
# Lycée Hoche, Versailles
# L.-C. LEFÈVRE

#%% modules et fonctions globales
# exécuter une fois pour toute, regarder, ne pas toucher

import numpy as np
import matplotlib.pyplot as plt
import PIL

def afficher(X):
    # cmap nécessaire pour interpréter les niveaux de gris
    plt.imshow(X, cmap="gray")
    plt.show()

# affiche les images X et Y l'une au-dessus de l'autre
def afficher2(X, Y):
    plt.subplot(2, 1, 1)
    plt.imshow(X, cmap="gray")
    plt.subplot(2, 1, 2)
    plt.imshow(Y, cmap="gray")
    plt.show()

def taille(X):
    (n, p) = X.shape
    return (n, p)

def image_vierge(n, p):
    Y = np.zeros((n, p), dtype=np.uint8)
    return Y

def copie(X):
    Y = X.copy()
    return Y

# sauvegarde l'image X dans le fichier nommé nom
# par exemple sauvegarde(X, "nom.jpg")
def sauvegarde(X, nom):
    # f représente une image PIL
    f = PIL.Image.fromarray(X, mode="L")
    f.save(nom)

#%% paramètres utilisateurs globaux
# exécuter après chaque changement d'image

# choisir son image dans le dossier Photos
choix = "Photos/Hoche.jpg"

# chargement de l'image et test de l'affichage
with PIL.Image.open(choix) as f:
    # f représente un fichier image PIL
    # g est l'image PIL convertie en niveaux de gris
    g = f.convert("L")
    # image est un tableau numpy obtenu à partir de g
    image = np.asarray(g)
    # tests
    print("Image choisie :", choix)
    print("Mode (L : niveaux de gris, RGB : couleurs) :", g.mode)
    print("Dimensions du tableau :", image.shape)
    print("Type des données :", image.dtype)
    afficher(image)

# C'est partiiiiii

#%% exercice 1

def miroir(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            Y[i, j] = X[...]
    return Y

# test
Y = miroir(image)
afficher(Y)
#afficher2(image, Y)
#sauvegarde(Y, "test_miroir.jpg")

#%% exercice 2

def pivote(X):
    (n, p) = taille(X)
    Y = image_vierge(...)
    ...
    return Y

# test
Y = pivote(image)
afficher(Y)

#%% exercice 3

def eclaircit(X, b):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    ...
    return Y

# test
Y = eclaircit(image, 50)
afficher(Y)

#%% exercice 4

def seuillage(X, s):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    ...
    return Y

# test
Y = seuillage(image, 127)
afficher(Y)

#%% exercice 5

def contraste(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    ...
    return Y

# test
Y = contraste(image)
afficher(Y)

#%% exercice 6

def negatif(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    ...
    return Y

# test
Y = negatif(image)
afficher(Y)

#%% exercice 7

def flou(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    ...
    return Y

# test
Y = flou(image)
afficher(Y)

#%%
# test de flou plus fort (attention au temps d'exécution)

Y = image
for _ in range(10):
    Y = flou(Y)
afficher(Y)

#%% exercice 8

def contours(X, s):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    ...
    return Y

# test (essayer plusieurs fois en réglant le seuil)
Y = contours(image, 50)
afficher(Y)

#%%
# la suite est en couleurs !
