# TP 16 (version couleurs) correction : Manipulation d'images
# BCPST1B 2025-2026
# Lycée Hoche, Versailles
# L.-C. LEFÈVRE

#%% modules et fonctions globales
# exécuter une fois pour toute, regarder, ne pas toucher

import numpy as np
import matplotlib.pyplot as plt
import PIL

def afficher(X):
    plt.imshow(X)
    plt.show()

# affiche les images X et Y les unes au-dessus des autres
def afficher2(X, Y):
    plt.subplot(2, 1, 1)
    plt.imshow(X)
    plt.subplot(2, 1, 2)
    plt.imshow(Y)
    plt.show()

def taille(X):
    (n, p, _) = X.shape
    return (n, p)

def image_vierge(n, p):
    Y = np.zeros((n, p, 3), dtype=np.uint8)
    return Y

def copie(X):
    Y = X.copy()
    return Y

# sauvegarde l'image X dans le fichier nommé nom
# par exemple sauvegarde(X, "nom.jpg")
def sauvegarde(X, nom):
    # f représente une image PIL
    f = PIL.Image.fromarray(X, mode="RGB")
    f.save(nom)

#%% paramètres utilisateurs globaux
# exécuter après chaque changement d'image

# choisir son image dans le dossier Photos
choix = "Photos/Hoche.jpg"

# chargement de l'image et test de l'affichage
with PIL.Image.open(choix) as f:
    # f représente un fichier image PIL
    # g est l'image PIL convertie en couleurs
    g = f.convert("RGB")
    # image est un tableau numpy obtenu à partir de g
    image = np.asarray(g)
    # tests
    print("Image choisie :", choix)
    print("Mode (L : niveaux de gris, RGB : couleurs) :", g.mode)
    print("Dimensions du tableau :", image.shape)
    print("Type des données :", image.dtype)
    afficher(image)

#%% exercice 9

def contraste(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            # contraste chaque couleur
            for c in range(3):
                if X[i, j, c] < 96:
                    Y[i, j, c] =  1/4 * X[i, j, c]
                elif X[i, j, c] < 160:
                    Y[i, j, c] = 24 + 13/4 * (X[i, j, c] - 96)
                else:
                    Y[i, j, c] = 232 + 1/4 * (X[i, j, c] - 160)
    return Y

# test
Y = contraste(image)
afficher2(image, Y)

#%%

def negatif(X):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            # inverse chaque couleur
            for c in range(3):
                Y[i, j, c] = 255 -  X[i, j, c]
    return Y

# test
Y = negatif(image)
afficher(Y)

#%% exercice 10

def seuillage(X, a, b, c):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            # seuil a pour le rouge
            if X[i, j, 0] <= a:
                Y[i, j, 0] = 0
            else:
                Y[i, j, 0] = 255
            # seuil b pour le vert
            if X[i, j, 1] <= b:
                Y[i, j, 1] = 0
            else:
                Y[i, j, 1] = 255
            # seuil c pour bleu
            if X[i, j, 2] <= c:
                Y[i, j, 2] = 0
            else:
                Y[i, j, 2] = 255
    return Y

# test
Y = seuillage(image, 127, 127, 127)
afficher(Y)

#%%
# autre test
choix = "Photos/Amsterdam.jpg"
with PIL.Image.open(choix) as f:
    g = f.convert("RGB")
    image_Amsterdam = np.asarray(g)

Y = seuillage(image_Amsterdam, 127, 127, 127)
afficher(Y)

#%%
# autre test
choix = "Photos/chats.jpg"
with PIL.Image.open(choix) as f:
    g = f.convert("RGB")
    image_chats = np.asarray(g)

Y = seuillage(image_chats, 160, 127, 127)
afficher(Y)

#%% exercice 11

def fusion(X1, X2):
    (n, p) = taille(X1)
    (n2, p2) = taille(X2)
    assert n == n2 and p == p2, "Les images à fusionner doivent être exactement de la même taille"
    Y = image_vierge(n, p)
    for i in range(n):
        for j in range(p):
            Y[i, j] = 1/2 * X1[i, j] + 1/2 * X2[i, j]
    return Y

# test
choix1 = "Photos/Hoche.jpg"
choix2 = "Photos/Miami.jpg"
with PIL.Image.open(choix1) as f1, PIL.Image.open(choix2) as f2:
    g1 = f1.convert("RGB")
    X1 = np.asarray(g1)
    g2 = f2.convert("RGB")
    X2 = np.asarray(g2)

Y = fusion(X1, X2)
afficher(Y)

#%% bonus spécial

# fusionne un rectangle de X2 découpé à partir du coin (a, b), de dimensions (u, v)
# à coller dans X1 à partir du coin (x, y)
# avec un paramètre de transparence r entre 0 et 1
def fusion2(X1, X2, x, y, a, b, u, v, r):
    (n, p) = taille(X1)
    (n2, p2) = taille(X2)
    assert a+u < n2 and x+u < n and b+v < p2 and y+v < p, "Ça ne rentre pas !"
    Y = copie(X1)
    for i in range(u):
        for j in range(v):
            Y[x+i, y+j] = (1-r) * X1[x+i, y+j] + r * X2[a+i, b+j]
    return Y

choix1 = "Photos/Hoche.jpg"
choix2 = "Photos/surf.jpg"
with PIL.Image.open(choix1) as f1, PIL.Image.open(choix2) as f2:
    g1 = f1.convert("RGB")
    image_Hoche = np.asarray(g1)
    g2 = f2.convert("RGB")
    image_surf = np.asarray(g2)

Y = fusion2(image_Hoche, image_surf, 115, 53, 115, 47, 184, 205, 2/3)
afficher(Y)

#%% artistique

def art(X):
    (n, p) = taille(X)
    Y = image_vierge(2*n, 2*p)
    for i in range(n):
        for j in range(p):
            Y[i, j, 0] = X[i, j, 0]
            Y[i, j, 1] = 0
            Y[i, j, 2] = 0
            Y[n+i, j, 0] = 0
            Y[n+i, j, 1] = X[i, j, 1]
            Y[n+i, j, 2] = 0
            Y[i, p+j, 0] = 0
            Y[i, p+j, 1] = 0
            Y[i, p+j, 2] = X[i, j, 2]
            Y[i+n, p+j, 0] = X[i, j, 0]
            Y[i+n, p+j, 1] = X[i, j, 1]
            Y[i+n, p+j, 2] = X[i, j, 2]
    return Y

choix = "Photos/chats.jpg"
with PIL.Image.open(choix) as f:
    g = f.convert("RGB")
    image_chats = np.asarray(g)

Y = art(image_chats)
afficher(Y)
