# TP 16 (fichier à compléter, version couleurs) : Manipulation d'images
# BCPST1B 2025-2026
# Lycée Hoche, Versailles
# L.-C. LEFÈVRE

#%% modules et fonctions globales
# exécuter une fois pour toute, regarder, ne pas toucher

import numpy as np
import matplotlib.pyplot as plt
import PIL

def afficher(X):
    plt.imshow(X)
    plt.show()

# affiche les images X et Y l'une au-dessus de l'autre
def afficher2(X, Y):
    plt.subplot(2, 1, 1)
    plt.imshow(X)
    plt.subplot(2, 1, 2)
    plt.imshow(Y)
    plt.show()

def taille(X):
    (n, p, _) = X.shape
    return (n, p)

def image_vierge(n, p):
    Y = np.zeros((n, p, 3), dtype=np.uint8)
    return Y

def copie(X):
    Y = X.copy()
    return Y

# sauvegarde l'image X dans le fichier nommé nom
# par exemple sauvegarde(X, "nom.jpg")
def sauvegarde(X, nom):
    # f représente une image PIL
    f = PIL.Image.fromarray(X, mode="RGB")
    f.save(nom)

#%% paramètres utilisateurs globaux
# exécuter après chaque changement d'image

# choisir son image dans le dossier Photos
choix = "Photos/Hoche.jpg"

# chargement de l'image et test de l'affichage
with PIL.Image.open(choix) as f:
    # f représente un fichier image PIL
    # g est l'image PIL convertie en couleurs
    g = f.convert("RGB")
    # image est un tableau numpy obtenu à partir de g
    image = np.asarray(g)
    # tests
    print("Image choisie :", choix)
    print("Mode (L : niveaux de gris, RGB : couleurs) :", g.mode)
    print("Dimensions du tableau :", image.shape)
    print("Type des données :", image.dtype)
    afficher(image)

#%% exercice 9
# copier-coller et adapter les fonctions en niveaux de gris

#%% exercice 10

def seuillage(X, a, b, c):
    (n, p) = taille(X)
    Y = image_vierge(n, p)
    ...
    return Y

# test
Y = seuillage(image, 127, 127, 127)
afficher(Y)

#%% exercice 11

def fusion(X1, X2):
    (n, p) = taille(X1)
    (n2, p2) = taille(X2)
    assert n == n2 and p == p2, "Les images à fusionner doivent être exactement de la même taille."
    Y = image_vierge(n, p)
    ...
    return Y

# test : les images Hoche et Miami sont de même dimension
choix1 = "Photos/..."
choix2 = "Photos/..."
with PIL.Image.open(choix1) as f1, PIL.Image.open(choix2) as f2:
    g1 = f1.convert("RGB")
    X1 = np.asarray(g1)
    g2 = f2.convert("RGB")
    X2 = np.asarray(g2)

Y = fusion(X1, X2)
afficher(Y)
