# TP 06 (fichier à compléter) : Algorithmes sur les listes
# BCPST1B 2025-2026
# Lycée Hoche, Versailles
# L.-C. LEFÈVRE

#%% importation des fonctions utiles
# exécuter une fois pour toute au début du TP

from random import randint, gauss

#%% partie I
# programme d'exemple : exécuter toute la cellule et observer

def compte_positifs(L):
    c = 0
    for i in range(len(L)):
        if L[i] >= 0:
            c = c + 1
    return c

# test avec une vraie liste
L = [8, -2, 3, -7, 2]
print("L =", L)
print(compte_positifs(L))
# avec une autre
L = [9, 3, 0, 2, 0]
print("L =", L)
print(compte_positifs(L))
# encore
L = [-2, -4, -4, -6, -1]
print("L =", L)
print(compte_positifs(L))
# test avec une liste aléatoire de 10 nombres
L = [randint(-5, 9) for _ in range(10)]
print("(liste aléatoire) L =", L)
print(compte_positifs(L))

#%% exercice 1

def compte(L, x):
    ...

# test
L = [2, 0, 1, 3, 8, 1, 8, 9, 7, 6]
x = 8
print("L =", L, "x =", x)
print(compte(L, x))
x = 5
print("L =", L, "x =", x)
print(compte(L, x))
# test avec une liste aléatoire
L = [randint(0, 5) for _ in range(10)]
x = 0
print("(liste aléatoire) L =", L, "x =", x)
print(compte(L, x))

#%% exercice 2

def différences(L, M):
    assert len(L) == len(M), "Les deux listes doivent être de même longueur."
    ...

# test
L = [3, 7, 6, 5, 3]
M = [3, 8, 6, 5, 4]
print("L =", L, "M =", M)
print(différences(L, M))

#%% exercice 3

def compte_voyelles(s):
    ...

# test
# se limiter à des caractères minuscules, sans accents
s = "versailles"
print("s =", s)
print(compte_voyelles(s))
s = "portez ce vieux whisky au juge blond qui fume"
print("s =", s)
print(compte_voyelles(s))
s = "" # à vous de jouer !
print("s =", s)
print(compte_voyelles(s))

#%% exercice 4

def somme(L):
    ...

# test avec une toute petite liste aléatoire
L = [randint(0, 9) for _ in range(3)]
print("(liste aléatoire) L =", L)
print(somme(L))

#%% exercice 5
# réfléchir, tester, observer

def tous_positifs_1(L):
    for i in range(len(L)):
        if L[i] >= 0:
            return True
        else:
            return False

def tous_positifs_2(L):
    for i in range(len(L)):
        if L[i] >= 0:
            return True
    return False

def tous_positifs_3(L):
    for i in range(len(L)):
        if L[i] < 0:
            return False
        else:
            return True

def tous_positifs_4(L):
    for i in range(len(L)):
        if L[i] < 0:
            return False
    return True

# test
L = [1, 3, 5, 7]
print("L =", L)
print(tous_positifs_1(L))
print(tous_positifs_2(L))
print(tous_positifs_3(L))
print(tous_positifs_4(L))
L = [-2, 4, 6, 8]
print("L =", L)
print(tous_positifs_1(L))
print(tous_positifs_2(L))
print(tous_positifs_3(L))
print(tous_positifs_4(L))
L = [10, 11, -12, 13]
print("L =", L)
print(tous_positifs_1(L))
print(tous_positifs_2(L))
print(tous_positifs_3(L))
print(tous_positifs_4(L))

#%% exercice 6

def binaire(m):
    ...

# test
m = "11111"
print("m =", m)
print(binaire(m))
m = "001101101"
print("m =", m)
print(binaire(m))
m = "00103010"
print("m =", m)
print(binaire(m))

#%% exercice 7

def est_croissante(L):
    ...

# test
L = [1, 3, 5, 7]
print("L =", L)
print(est_croissante(L))
L = [4, 3, 2, 1]
print("L =", L)
print(est_croissante(L))
L = [1, 5, 3, 7]
print("L =", L)
print(est_croissante(L))

#%% exercice 8

def cherche(L, x):
    for i in range(len(L)):
        if ... :
            ...

# test
L = [8, 7, 5, 0, 2, 5, 2, 5, 6, 3]
x = 5
print("L =", L, "x =", x)
print(cherche(L, x))
x = 8
print("L =", L, "x =", x)
print(cherche(L, x))
x = 3
print("L =", L, "x =", x)
print(cherche(L, x))
x = 1
print("L =", L, "x =", x)
print(cherche(L, x))

#%% exercice 9

def premier_negatif(L):
    ...

# test
L = [3, 5, -2, 8, -3]
print("L =", L)
print(premier_negatif(L))
L = [-3, 5, -1, 8, 7]
print("L =", L)
print(premier_negatif(L))
L = [3, 4, 2, 6]
print("L =", L)
print(premier_negatif(L))
# test avec une liste aléatoire
L = [randint(-3, 9) for _ in range(10)]
print("(liste aléatoire) L =", L)
print(premier_negatif(L))

#%% exercice 10

def indice_différents(s, t):
    assert len(s) == len(t), "Les deux chaines doivent être de même longueur."
    ...

# test
s = "ACGTGATAA"
t = "ACGTCATTA"
print("s =", s, "t =", t)
print(indice_différents(s, t))
s = "ACGTGATAA"
t = "ACGTGATAA"
print("s =", s, "t =", t)
print(indice_différents(s, t))

#%% exercice 11

def compte_tout(L):
    assert all(0 <= x and x <= 9 for x in L), "La liste ne doit contenir que des nombres entre 0 et 9 (inclus)."
    ...

# test
L = [3, 7, 5, 3, 2, 3, 0, 4, 7, 9, 3, 4, 3, 0, 4]
print("L =", L)
print(compte_tout(L))
# test avec une liste aléatoire
L = [randint(0, 9) for _ in range(30)]
print("(liste aléatoire) L =", L)
print(compte_tout(L))
# test avec une liste aléatoire biaisée
L = [min(max(int(gauss(3, 3)), 0), 9) for _ in range(30)]
print("(liste aléatoire) L =", L)
print(compte_tout(L))

#%%

# suite : s'inspirer et prendre des initiatives !
# on donne
# A = "abcdefghijklmnopqrstuvwxyz0123456789"
# B = "abcdefghijklmnopqrstuvwxyz"
# C = "0123456789"
