// Louis-Clément LEFÈVRE
//
// style de base pour les documents, inclus et utilisé par les autres styles

// style de base, très configurable
#let hoche(
  titre: none,
  titre-header: none,
  titre-PDF: none,
  code: none,
  numéro-pages: true,
  no-header: false,
  no-footer: false,
  no-document: false,
  classe: "BCPST1B",
  année: "2024" + sym.dash.en + "2025",
  auteur: "L.-C. LEFÈVRE",
  auteur-PDF: "Louis-Clément LEFÈVRE",
  lycée: "Lycée Hoche, Versailles",
  extra-keywords: (),
  body,
) = {
  set page(
    paper: "a4",
    margin: (x: 1cm, top: 1.3cm, bottom: 1.7cm),
    numbering: "1/1",
    header: if not no-header {
      // s'il y a un titre : pas de header sur la première page
      context {
        let p = counter(page).get().first()
        if p == 1 and titre != none { none }
        else {
          grid(
            columns: (1fr, 1fr, 1fr),
            align(left + horizon, code),
            align(center + top, titre-header),
            [],
          )
          v(6pt, weak: true)
          line(length: 100%, stroke: 0.4pt)
        }
      }
    } else {
      none
    },
    footer: if not no-footer {
      context {
        line(length: 100%, stroke: 0.4pt)
        v(6pt, weak: true)
        grid(
          columns: (1fr, 1fr, 1fr),
          align(left + horizon,
            classe + " " + année + linebreak() + lycée
          ),
          align(center + top,
            if numéro-pages {
              counter(page).display("1/1", both: true)
            } else {
              none
            }
          ),
          align(right + top,
            auteur
          ),
        )
      }
    } else {
      none
    }
  )

  set document(
    // titre : titre-PDF
    // sinon : code : titre
    title: {
      if titre-PDF != none {
        titre-PDF
      } else {
        if code != none and titre != none {
          code + " : " + titre
        } else if code != none {
          code
        } else if titre != none {
          titre
        } else {
          none
        }
      }
    },
    author: auteur-PDF,
    keywords: ("BCPST", "Lycée Hoche", ) + extra-keywords,
  ) if not no-document

  set text(
    size: 11pt,
    font: "New Computer Modern",
    lang: "fr",
  )

  set par(
    justify: true,
  )

  show raw: set text(
    // default raw : DejaVu Sans Mono
    // petite correction
    // https://github.com/typst/typst/issues/1331
    size: 1.25em,
    font: "New Computer Modern Mono",
    fallback: false,
  )

  // maths : police regular et non pas book
  show math.equation: set text(
    weight: 400,
    font: "New Computer Modern Math",
    fallback: false,
  )

  // guillemets français
  set smartquote(enabled: false)
  show regex("« "): it => "«" + sym.space.nobreak.narrow
  show regex(" »"): it => sym.space.nobreak.narrow + "»"

  set heading(
    numbering: "I.1",
    supplement: none,
  )

  set figure(
    supplement: "Figure",
  )
  
  // mise en forme du titre
  if titre != none {
    v(-0.5cm)
    align(center,
      text(size: 18pt, weight: "bold",
        titre
      )
    )
  }

  body
}

// formate des touches au clavier
// c'est une simple « illusion » de touche !!!
#let touchesclavier(..s) = {
  box({
    s.pos().map( x => {
      box(stroke: 0.4pt+black, outset: (y: 3pt), inset: (x: 3pt), radius: 3pt, fill: silver.lighten(50%),
        raw(lang: none,
          x
        )
      )
    }).join(box(inset: (x: 3pt),
      raw(lang: none,
        "+"
      )
    ))
  })
}

// Mathématiques

// ensembles
#let Max = math.op("Max", limits: true)
#let Min = math.op("Min", limits: true)
#let Sup = math.op("Sup", limits: true)
#let Inf = math.op("Inf", limits: true)
#let Card = math.op("Card", limits: false)
#let id = math.op("id", limits: false)
#let Id = math.op("Id", limits: false)
#let Var = math.op("Var", limits: false)

// algèbre linéaire
#let Hom = math.op("Hom", limits: true)
#let End = math.op("End", limits: true)
#let Aut = math.op("Aut", limits: true)
#let Ker = math.op("Ker", limits: false)
#let Im = math.op("Im", limits: false)
#let Tr = math.op("Tr", limits: false)
#let Vect = math.op("Vect", limits: false)
#let deg = math.op("deg", limits: false)
#let rg = math.op("rg", limits: false)

// symboles
#let leq = math.lt.eq.slant
#let geq = math.gt.eq.slant
#let circ = math.class("binary", math.circle.stroked.small)
#let RRe = math.op(sym.Re + "e", limits: false)
#let IIm = math.op(sym.Im + "m", limits: false)
