// Louis-Clément LEFÈVRE
//
// style pour créer un programme de colle

#import "hoche.typ": *

#let hoche-colle(
  numéro: none,
  date: none,
  star: false,
  body
) = {
  assert(numéro == none or 0 <= numéro)
  assert(star == false or numéro != none)
  let numéro2 = if numéro != none {
    if numéro < 10 {
      "0" + str(numéro)
    } else {
      str(numéro)
    }
  } else {
    none
  }
  let titre-page = "Programme de colle" + if numéro != none { sym.space.nobreak + str(numéro) + if star { "*" } } + if date != none { linebreak() + date }
  let titre-header = "Programme de colle" + if numéro != none { sym.space.nobreak + numéro2 + if star { "*" } }
  let titre-PDF = if numéro != none { "Semaine" + " " + numéro2 + if star { "*" } } else { "Programme de colle" }
  let code = if numéro != none { "Semaine" + " " + numéro2 + if star { "*" } } else { none }
  show: hoche.with(
    titre: titre-page,
    titre-header: date,
    titre-PDF: titre-PDF,
    code: code,
    extra-keywords: ("mathématiques", "programme de colle", ),
  )
  set heading(numbering: none)
  show heading.where(level: 1): it => block(
    stroke: ("bottom": 0.4pt),
    width: 100%,
    inset: ("bottom": 6pt),
    above: 1.2em,
    it
  )
  show heading.where(level: 2): it => {
    set text(size: 11pt, weight: "bold")
    block(above: 0.8em, it)
  }
  
  body
}

#let notions(body) = {
  block[
    = Notions
    #sym.arrow.r.curve; _En un coup d'œil, les notions qui ont été vues en cours et sur lesquelles portent les colles de la semaine._
  ]
  body
}

#let savoirfaire(body) = {
  block[
    = Savoir-faire
    #sym.arrow.r.curve; _Description des compétences attendues et des types d'exercices possibles._
  ]
  body
}

#let cours(body) = {
  block[
    = Questions de cours
    #sym.arrow.r.curve; _Les questions à travailler et à savoir refaire, incluant l'énoncé précis et la démonstration._
  ]
  body
}
