// Louis-Clément LEFÈVRE
//
// style pour les TP d'informatique (Python ou bien SQL)

#import "hoche.typ": *

#let hoche-TP(
  numéro: none,
  titre: none,
  keywords: none,
  body
) = {
  assert(numéro == none or 0 <= numéro)
  let numéro2 = if numéro != none {
    if numéro < 10 {
      "0" + str(numéro)
    } else {
      str(numéro)
    }
  } else {
    none
  }
  let titre-page = "TP" + if numéro != none { sym.space.nobreak + str(numéro) } + if titre != none { linebreak() + titre }
  let titre-header = titre
  let titre-PDF = if numéro != none { "TP" + " " + numéro2 + " : " + titre } else if titre != none { titre } else { "TP" }
  let code = if numéro != none { "TP" + " " + numéro2 } else { none }
  show: hoche.with(
    titre: titre-page,
    titre-header: titre,
    titre-PDF: titre-PDF,
    code: code,
    extra-keywords: ("informatique", ) + keywords,
  )

  // style latex
  set par(leading: 0.55em)
  // utiliser depth : plus facile à décaler ensuite
  show heading.where(depth: 1): set text(11pt * 1.4)
  show heading.where(depth: 2): set text(11pt * 1.2)
  show heading.where(depth: 3): set text(11pt)
  show heading: set block(above: 1.4em, below: 1em)
  show heading: it => block( context {
    counter(heading).display() + h(1em) + it.body
  })
  show heading.where(depth: 3): it => {
    strong(it.body) + h(2em)
  }

  // code
  let _block_raw(it) = {
    block(
      breakable: false,
      fill: silver.lighten(50%),
      radius: 6pt,
      inset: 6pt,
      width: 100%,
      it
    )
  }

  // le thème qui va bien
  set raw(theme: "Pastie.tmTheme")
  // set raw(syntaxes: "SQL.sublime-syntax")
  show raw.where(block: true): _block_raw
  // « faux » mode console Python, on peut encore affiner
  show raw.where(block: true, lang: "pycon"): it => _block_raw({
    it.text.split("\n").map(ligne => {
      if ligne.starts-with(">>>") { raw(lang: "python", ligne) }
      else if ligne.starts-with(regex("(AssertionError)|(KeyError)|(IndexError)|(TypeError)|(ZeroDivisionError)\\:")) {
        set text(fill: red)
        raw(lang: "text", ligne)
      } else {
        let i = ligne.position("#")
        if i == none {
          raw(lang: "text", ligne)
        } else {
          let a = ligne.slice(0, i)
          let b = ligne.slice(i)
          raw(lang: "text", a) + raw(lang: "python", b)
        }
      }
    }).join(linebreak())
  })
  show raw.where(block: false, lang: "pycon"): it => raw(lang: "python", it.text)

  show table: set block(breakable: false)
  set table(
    stroke: 0.4pt,
    inset: 3pt,
  )

  // important pour la numérotation des questions dans les exercices
  set enum(
    number-align: start+top,
    body-indent: 0em,
    full: true,
    numbering: (..n) => {
      if n.pos().len() == 1 {
        box(width: 18pt, numbering("1.", ..n))
      } else if n.pos().len() == 2 {
        align(center,
          numbering("(i)", ..(n.pos().slice(1))) + h(3pt)
        )
      } else {
        numbering("1.", ..(n.pos().slice(2))) + h(3pt)
      }
    },
  )

  counter("exercice").update(0)

  body
}

// style d'exercices
#let exercice(
  soustitre: none,
  difficulté: none,
  body
) = {
  counter("exercice").step()
  block(
    inset: 6pt,
    width: 100%,
    radius: 6pt,
    stroke: 0.4pt + black, {
      context {
        block(below: 0.55em, sticky: true, {
          strong("Exercice" + sym.space.nobreak + counter("exercice").display())
          if difficulté != none {
            sym.space
            strong(
              "(" + for _ in range(difficulté) { "*" } + ")"
            )
          }
          if soustitre != none {
            h(1em) + emph(soustitre)
          }
        })
        body
      }
    }
  )
}

#let _boitecouleur(couleur, message, body) = {
  block(
    width: 100%,
    radius: 6pt,
    breakable: false,
    stroke: 1pt+couleur,
    fill: couleur.lighten(90%),
    {
      block(
        sticky: true,
        width: 100%,
        inset: 6pt,
        fill: couleur,
        radius: (top: 6pt),
        below: 0pt,
        text(fill: white, strong(message))
      )
      pad(6pt, body)
    }
  )
}

#let boiteavertissement(body) = {
  _boitecouleur(red, "Avertissement", body)
}

#let boitearetenir(body) = {
  _boitecouleur(blue, "À retenir", body)
}

#let thmtheorem(body) = {
  _boitecouleur(green, "Théorème", body)
}

#let thmqed = {
  h(1fr) + sym.wj + sym.space.nobreak + $square.stroked$
}

// encore un peu améliorable
#let thmremark(body) = {
  block(
    width: 100%,
    {
      [_Remarque._] + [ ]
      body
    }
  )
}

#let thmdefinition(body) = {
  _boitecouleur(green, "Définition", body)
}

#let thmproof(qed: true, body) = {
  block(
    width: 100%,
    {
      [_Démonstration._] + [ ]
      body
      if qed { thmqed }
    }
  )
}
