// Louis-Clément LEFÈVRE
//
// Exemple : programme de colle de la semaine 12

#import "/hoche-colle.typ": *
#show: hoche-colle.with(
  numéro: 12,
  date: "16 au 20 décembre 2024",
)

#notions[
  == Chapitre 10 : Systèmes linéaires
  - Notion de système linéaire, matrice des coefficients, second membre, homogénéité, compatibilité.
  - L'algorithme du pivot de Gauss, les trois opérations élémentaires, notion de système échelonné. Inconnues principales et inconnues libres, équations principales et conditions de compatibilité, rang. Systèmes de Cramer, systèmes de rang maximal.
  == Chapitre 11 : Dénombrement
  - Ensembles finis, cardinal, inclusion, intersection. Applications injectives ou surjectives ou bijectives entre ensembles finis.
  - Cardinaux des constructions usuelles sur les ensembles : union, produit cartésien, listes d'éléments de $E$, applications $E -> F$, listes sans répétitions, permutations. Parties de $E$ à $k$ éléments, parties de $E$.
  - Interprétation combinatoire des formules sur les coefficients binomiaux.
]

#savoirfaire[
  - Échelonner et résoudre un système linéaire. Utiliser les opérations élémentaires. Donner le rang, les conditions de compatibilité, les inconnues libres.
  - Étudier des systèmes linéaires avec des paramètres.
  - Dénombrer dans de nombreuses situations concrètes, notamment en se ramenant aux constructions sur les ensembles.
  - Exemples de situations : asseoir des gens, former des groupes de gens, jeux de 32 cartes, former des mots, anagrammes, …
]

#cours[
  - (exercice) Soit $E$ l'ensemble des polynômes de degré au plus $2$, soit l'application $φ : cases(E -> RR^3, P |-> (P(1), P(2), P(3)))$. Montrer avec un système linéaire que $φ$ est bijective puis donner l'application réciproque.
  - (exercice) Idem avec $ψ : cases(E -> RR^3, P |-> (P(1), P'(2), P(3)))$. Montrer avec un système linéaire que $ψ$ n'est ni injective ni surjective.
  - (exercice) Donner toutes les solutions de $cal(S)_λ : cases(4x + 6y = λ x, -x -y = λ y)$, d'inconnue $(x, y) ∈ RR^2$, en fonction du paramètre $λ ∈ RR$.
  - $Card(A ∪ B) = Card(A) + Card(B) - Card(A ∩ B)$
  - Si les $A_1, …, A_n$ sont deux à deux disjonts alors $Card(union.big_(i=1)^n A_i) = sum_(i=1)^n Card(A_i)$.
  - $Card(A × B) = Card(A) × Card(B)$
  - Cardinal de l'ensemble des parties de $E$ via les fonctions indicatrices : $Ψ : cases(cal(P)(E) -> {0,1}^E, A |-> chi_A)$ est une bijection.
]
