// Louis-Clément LEFÈVRE
//
// Exemple : cahier de texte 2024-2025 en entier

#import "/hoche-cdt.typ": *
#show: hoche-cdt

#statistiques()

#semaine(numéro: 35, date: "23 au 29 juin 2025",
  séance(type: "spécial", date: "Jeudi 26/06",
    [Sortie au Museum national d'Histoire naturelle], [
      - Galerie de paléotonlogie
      - Galerie de minéralogie
      - Grande galerie de l'évolution
    ],
  ),
  séance(type: "cours", date: "Mardi 24/06", durée: 2, x2: false, spécial: true,
    [Révisions], [
      - Applications linéaires, projecteurs et symétries.
      - Intégration, méthode des rectangles au milieu.
    ],
  ),
  séance(type: "spécial", date: "Lundi 23/06",
    [Conseil de classe du second semestre], [],
  ),
  séance(type: "TD", date: "Lundi 23/06", durée: 3, x2: true,
    [Retour DM 6], [],
    [TD 27 : Intégration], [
      - Fonctions des bornes de l'intégrale.
    ],
    [TP 26 : Intégration numérique], [
      - Rectangles à gauche, à droite, au milieu, méthode des trapèzes, méthode de Simpson, étude mathématique et étude numérique.
    ]
  ),
)

#semaine(numéro: 34, date: "16 au 22 juin 2025",
  séance(type: "spécial", date: "Vendredi 20/06",
    [Soutenances de TIPE], [],
  ),
  séance(type: "cours", date: "Vendredi 20/06", durée: 2,
    [Chapitre 28 : Fonctions à plusieurs variables], [
      - III.4 Gradient et lignes de niveaux.
      - IV Dérivées partielles secondes, fonctions $cal(C)^2$, théorème de Schwarz, étude d'un contre-exemple.
      - V Applications aux statistiques, rappels sur les statistiques à une variable, statistiques à deux variables, point moyen, covariance, formule de König-Huygens pour la covariance, droite de régression affine en minimisant une fonction à deux variables, coefficient de corrélation linéaire.
    ],
  ),
  séance(type: "spécial", date: "Jeudi 19/06",
    [Soutenances de TIPE], [],
  ),
  séance(type: "cours", date: "Mercredi 18/06", durée: 2,
    [Chapitre 28 : Fonctions à plusieurs variables], [
      - III.2 Extrema, extrema locaux, dérivées partielles et extrema locaux, points critiques, points selles.
      - III.3 Développement limité à l'ordre 1, dérivée de $t |-> f(u(t), v(t))$.
      - III.4 Vecteur gradient, étude d'exemples.
    ],
  ),
  séance(type: "cours", date: "Mardi 17/06", durée: (1, 30), x2: false, spécial: true,
    [Chapitre 28 : Fonctions à plusieurs variables], [
      - II Continuité, opérations sur les fonctions continues, étude d'un contre-exemple.
      - III.1 Dérivées partielles, fonctions $cal(C)^1$, opérations sur les fonctions $cal(C)^1$.
    ],
  ),
  séance(type: "TD", date: "Lundi 16/06", durée: 3, x2: true,
    [TD 26 : Applications linéaires], [
      - Injectivité et surjectivité.
    ],
    [TD 27 : Intégration], [
      - Sommes de Riemann.
    ]
  ),
)

#semaine(numéro: 33, date: "9 au 15 juin 2025",
  séance(type: "spécial", date: [Mercredi~11 au\ Vendredi~13/06],
    [Voyage en Auvergne], [
      - Mercredi : voyage aller, carrière de Gandaillat.
      - Jeudi : affleurements, lac d'Aydat, Puy de Dôme.
      - Vendredi : volcan de Lemptégy, voyage retour.
    ],
  ),
  séance(type: "cours", date: "Mardi 10/06", durée: 2, x2: false, spécial: true,
    [Chapitre 28 : Fonctions à plusieurs variables], [
      - I.3 Représentations graphiques, graphe, courbes de niveau, étude d'exemples.
    ],
  ),
)

#semaine(numéro: 32, date: "2 au 8 juin 2025",
  séance(type: "cours", date: "Vendredi 6/06", durée: (3, 30),
    [Interrogation 1], [],
    [Chapitre 27 : Intégration], [
      - III Théorème fondamental du calcul intégral, rappel sur l'intégration par parties, rappel sur le changement de variables, intégrales dont les bornes sont des fonctions.
    ],
    [Chapitre 28 : Fonctions à plusieurs variables], [
      - I.1 Notion de fonction à plusieurs variables, domaine de définition, fonctions partielles.
      - I.2 Parties de $RR^n$, pavés ouverts et fermés, disques ouverts et fermés, intérieur d'une partie.
    ],
  ),
  séance(type: "cours", date: "Mercredi 4/06", durée: 2,
    [Chapitre 27 : Intégration], [
      - I Méthode des rectangles à droite, application aux sommes de Riemann.
      - II Propriétés de l'intégrale se démontrant à partir des sommes de Riemann, linéarité, positivité, croissance, inégalité triangulaire, définition de la valeur moyenne, relation de Chasles, positivé stricte.
    ]
  ),
  séance(type: "cours", date: "Mardi 3/06", durée: 2, x2: false, spécial: true,
    [Chapitre 26 : Applications linéaires], [
      - III.1 Expression d'une application linéaire dans une base mieux adaptée.
      - III.2 Opérations sur les applications linéaires et sur les matrices, somme, produit, inverse, rang.
    ],
    [Chapitre 27 : Intégration], [
      - I Méthode des rectangles à gauche.
    ],
  ),
  séance(type: "TD", date: "Lundi 2/06", durée: 3, x2: true,
    [Retour DS 8], [],
    [TD 25 : Développements limités], [
      - Limites, position par rapport à la tangente et à l'asymptote.
    ],
    [TD 26 : Applications linéaires], [
      - Noyau et image.
    ],
  ),
)

#semaine(numéro: 31, date: "26 mai au 1 juin 2025",
  séance(type: "cours", date: "Mercredi 28/05", durée: 2,
    [Chapitre 26 : Applications linéaires], [
      - II.1 Application linéaire $E -> F$ déterminée par une base de $E$.
      - II.2 Rang, le théorème du rang, conséquences.
      - III.1 Matrice d'une application linéaire dans des bases.
    ],
  ),
  séance(type: "cours", date: "Mardi 27/05", durée: 2, x2: false, spécial: true,
    [Chapitre 26 : Applications linéaires], [
      - I.2 Application nulle, identité, puissances, endomorphismes, isomorphismes, automorphismes, exemples de calculs.
      - II.1 Noyau, image, injectivité et surjectivité d'une application linéaire, application linéaire $RR^p -> E$ associée à une famille de $p$ vecteurs de $E$.
    ],
  ),
  séance(type: "TD", date: "Lundi 26/05", durée: 3, x2: true,
    [TD 25 : Développements limités], [
      - Calculs de développements limités, identification des coefficients.
    ],
  ),
)

#semaine(numéro: 30, date: "19 au 25 mai 2025",
  séance(type: "cours", date: "Vendredi 23/05", durée: (3, 30),
    [Chapitre 25 : Développements limités], [
      - III.1 Exemple de calculs de limites.
      - III.2 Étude des extrema locaux, position par rapport à la tangente, points ordinaires et points d'inflexion.
      - III.3 Développements asymptotiques, position par rapport à l'asymptote.
    ],
    [Chapitre 26 : Applications linéaires], [
      - I.1 Notion d'application linéaire, caractérisations équivalentes, quelques constructions.
      - I.2 Opérations sur les applications linéaires, produit par une constante, somme, composition, réciproque, distributivité de la composition sur la somme.
    ],
  ),
  séance(type: "cours", date: "Mercredi 21/05", durée: 2,
    [Chapitre 25 : Développements limités], [
      - II.3 Primitiver et dériver un développement limité.
      - II.4 La formule de Taylor, application aux développements limités usuels.
      - III.1 Donner un équivalent à partir d'un développement limité.
    ],
  ),
  séance(type: "cours", date: "Mardi 20/05", durée: 2, x2: false, spécial: true,
    [Chapitre 25 : Développements limités], [
      - II.1 Définition d'un développement limité, développements limités à l'ordre $0$ et $1$, tronquer un développement limité, unicité.
      - II.2 Somme, produit, composition, de développements limités.
    ],
  ),
  séance(type: "TD", date: "Lundi 19/05", durée: 3, x2: true,
    [TD 24 : Dérivation], [
      - Théorème des accroissements finis, dérivées supérieures, prolongement et recollement, méthode de Newton.
    ],
    [DM 6 pour le 3/06], [],
  ),
)

#semaine(numéro: 29, date: "12 au 18 mai 2025",
  séance(type: "DS", date: "Samedi 17/05", durée: 3,
    [DS 8], [],
  ),
  séance(type: "cours", date: "Vendredi 16/05", durée: (3, 30),
    [Chapitre 24 : Dérivation], [
      - III Fonctions à dérivée non continue, fonctions $cal(C)^n$ et $cal(C)^oo$, dérivées supérieures, opérations usuelles sur les fonctions $cal(C)^n$, dérivées de $x |-> x^n$, fonctions usuelles, problèmes de recollement.
    ],
    [Chapitre 25 : Développements limités], [
      - I Introduction, motivation pour le calcul de limites et de formes indéterminées.
    ],
  ),
  séance(type: "cours", date: "Mercredi 14/05", durée: 2,
    [Chapitre 24 : Dérivation], [
      - I.2 Dérivée d'une composée.
      - II.1 Dérivée et sens de variation partie 1, dérivée et extremum.
      - II.2 Le théorème de Rolle.
      - II.3 Le théorème des accroissements finis.
      - II.4 Dérivée et sens de variation partie 2, cas des fonctions strictement croissantes.
    ],
  ),
  séance(type: "TP", date: "Mardi 13/05", durée: 2, x2: true,
    [TP 25 : Fichiers texte], [
      - Notion sur le système de fichiers, droits, processus de lecture et d'écriture.
      - Lecture, écriture, lire d'un côté et écrire de l'autre.
    ],
  ),
  séance(type: "TD", date: "Lundi 12/05", durée: 3, x2: true,
    [TD 23 : Variables aléatoires], [
      - Manipuler des variables aléatoires, donner la loi, calculer l'espérance et la variance.
    ],
  ),
)

#semaine(numéro: 28, date: "5 au 11 mai 2025",
  séance(type: "cours", date: "Vendredi 9/05", durée: (3, 30),
    [Chapitre 23 : Variables aléatoires], [
      - III Variance d'une somme de variables aléatoires indépendantes, notions sur la covariance.
      - IV Loi certaine, loi uniforme, loi de Bernoulli, loi binomiale, illustration de la planche de Galton, notions sur la loi uniforme sur $[a, b]$.
    ],
    [Chapitre 24 : Dérivation], [
      - I.1 Taux de variation, dérivées à droite et à gauche, demi-tangentes.
      - I.2 Développement limité à l'ordre~1, une fonction dérivable est continue, application à la dérivée de la somme et du produit.
    ],
  ),
  séance(type: "cours", date: "Mercredi 7/05", durée: 2,
    [Chapitre 23 : Variables aléatoires], [
      - II.2 Linéarité de l'espérance, formule de transfert.
      - II.3 Variance, formule de König-Huygens, moments d'une variable aléatoire, écart-type, variables aléatoires centrées réduites.
      - III Variables aléatoires indépendantes, variables aléatoires indépendantes et identiquement distribuées, espérance d'un produit de variables aléatoires indépendantes.
    ],
  ),
  séance(type: "spécial", date: "Mardi 6/05", durée: 2, x2: false, spécial: true,
    [TIPE], [
      - Séance informatique pour le TIPE.
    ],
  ),
  séance(type: "TD", date: "Lundi 5/05", durée: 3, x2: true,
    [Révisions], [
      - Probabilités vers les variables aléatoires.
    ],
  ),
)

#semaine(numéro: 27, date: "28 avril au 4 mai 2025",
  séance(type: "cours", date: "Mercredi 30/04", durée: 2,
    [Chapitre 23 : Variables aléatoires], [
      - I.1 Notion de variable aléatoire, ensemble des valeurs prises.
      - I.2 Loi d'une variable aléatoire, présentation sous forme de tableau, fonction de répartition, tableau des probabilités cumulées, application à la simulation de variables aléatoires en Python.
      - II.1 Opérations algébriques sur les variables aléatoires, variable indicatrice d'un évènement.
      - II.2 Espérance, propriétés de croissance.
    ],
  ),
  séance(type: "TP", date: "Mardi 29/04", durée: 2, x2: true,
    [TP 24 : Statistiques], [
      - Applications et révision du chapitre de Mathématiques.
      - Fonctions Python de calcul des divers indicateurs statistiques, représentations graphiques via la bibliothèque Pandas.
      - Étude d'une situation.
    ],
  ),
  séance(type: "TD", date: "Lundi 28/04", durée: 3, x2: true,
    [TD 22 : Continuité], [
      - Prolongements par continuité, applications de la continuité.
    ],
  ),
)

= Vacances de printemps : 14 au 27 avril 2025

#semaine(numéro: 26, date: "7 au 13 avril 2025",
  séance(type: "cours", date: "Vendredi 11/04", durée: (3, 30),
    [Retour DS 7], [],
    [Chapitre 22 : Continuité], [
      - II.1 Programme Python de recherche de solution par dichotomie, nombre d'étapes et précision de l'approximation, l'image d'un intervalle par une fonction continue est un intervalle.
      - II.2 Le théorème des bornes, divers contre-exemples.
      - II.3 Le théorème de la bijection continue.
    ],
  ),
  séance(type: "cours", date: "Mercredi 9/04", durée: 2,
    [Chapitre 22 : Continuité], [
      - I.1 Continuité, à droite et à gauche.
      - I.2 Opérations sur les fonctions continues, continuité sur un intervalle.
      - I.3 Prolongement par continuité.
      - II.1 Méthode de dichotomie sur l'exemple de $sqrt(2)$, théorème des valeurs intermédiaires.
    ],
  ),
  séance(type: "TP", date: "Mardi 8/04", durée: 2, x2: true,
    [TP 23 : Langage SQL partie 2], [
      - Structure des bases de données, clés primaires et secondaires, jointures.
    ],
  ),
  séance(type: "TD", date: "Lundi 7/04", durée: 3, x2: true,
    [TD 21 : Limites de fonctions], [
      - Calcul de limites.
    ],
  ),
)

#semaine(numéro: 25, date: "31 mars au 6 avril 2025",
  séance(type: "DS", date: "Samedi 5/04", durée: 3,
    [DS 7], [],
  ),
  séance(type: "cours", date: "Vendredi 4/04", durée: (3, 30),
    [Chapitre 21 : Limites de fonctions], [
      - I.6 Notion de voisinage.
      - II Signe de la limite, passage des limites aux inégalités, théorème des gendarmes, théorème de la limite monotone.
      - III.1 Comparaisons et notation petit $o$ pour les fonctions.
      - III.2 Équivalents, manipulation des équivalents, équivalents usuels, application au calcul de limites.
    ],
  ),
  séance(type: "cours", date: "Mercredi 2/04", durée: 2,
    [Chapitre 21 : Limites de fonctions], [
      - I.1 Définition de limites de fonctions dans tous les cas.
      - I.2 Remarques, symétries et changements de variables dans les calculs de limites.
      - I.3 Limites à droite et à gauche.
      - I.4 Unicité de la limite, existence des limites à droite et à gauche.
      - I.5 Critère séquentiel, application aux compositions de limites et à toutes les opérations sur les limites.
    ],
  ),
  séance(type: "TP", date: "Mardi 1/04", durée: 2, x2: true,
    [TP 22 : Langage SQL partie 1], [
      - Prise en main. Sélection dans une seule table.
    ],
  ),
  séance(type: "TD", date: "Lundi 31/03", durée: 3, x2: true,
    [TD 20 : Espaces vectoriels], [
      - Manipuler des familles de vecteurs et des sous-espaces vectoriels de $RR^n$.
    ],
  ),
)

#semaine(numéro: 24, date: "24 au 30 mars 2025",
  séance(type: "cours", date: "Vendredi 28/03", durée: (3, 30),
    [Chapitre 20 : Espaces vectoriels], [
      - III.3 Bases.
      - IV.1 Dimension d'un sous-espace vectoriel.
      - IV.2 Extraire une base, compléter en bases, théorèmes sur la dimension.
      - IV.3 Matrice d'une famille de vecteurs dans une base.
      - IV.4 Rang d'une famille de vecteurs, échelonner la matrice d'une famille de vecteurs.
    ],
  ),
  séance(type: "cours", date: "Mercredi 26/03", durée: 2,
    [Chapitre 20 : Espaces vectoriels], [
      - II.4 Convertir entre équations et paramétrage pour un sous-espace vectoriel.
      - III.1 Familles libres de vecteurs, unicité des coefficients d'une combinaison linéaire.
      - III.2 Familles génératrices.
    ],
  ),
  séance(type: "TP", date: "Mardi 25/03", durée: 2, x2: true,
    [TP 21 : Aléatoire], [
      - Simulation de tirages aléatoires. Processus aléatoires.
    ],
  ),
  séance(type: "TD", date: "Lundi 24/03", durée: 3, x2: true,
    [TD 19 : Probabilités], [
      - Révisions dénombrement, probabilités composées, probabilités totales et formule de Bayes.
    ],
  ),
)

#semaine(numéro: 23, date: "17 au 23 mars 2025",
  séance(type: "cours", date: "Vendredi 21/03", durée: (3, 30),
    [Retour DS 6], [],
    [Chapitre 20 : Espaces vectoriels], [
      - I L'espace vectoriel $RR^n$, notions de vecteurs et de scalaires, corps $RR$ et $CC$, combinaisons linéaires.
      - II.1 Sous-espaces vectoriels, caractérisations équivalentes, ensemble des solutions d'une équation linéaire homogène.
      - II.2 Intersection de sous-espaces vectoriels.
      - II.3 Sous-espace vectoriel engendré par une famille de vecteurs, notation $Vect$.
    ],
  ),
  séance(type: "cours", date: "Mercredi 19/03", durée: 2,
    [Chapitre 19 : Probabilités], [
      - II.3 Applications des probabilités totales.
      - II.4 La formule de Bayes.
      - III Indépendance pour deux évènements, évènements indépendants dans leur ensemble.
    ],
  ),
  séance(type: "TP", date: "Mardi 18/03", durée: 2, x2: true,
    [TP 20 : Parcours de graphes], [
      - Parcours en profondeur, parcours en largeur, plus court chemin.
    ],
  ),
  séance(type: "TD", date: "Lundi 17/03", durée: 3, x2: true,
    [TD 18 : Polynômes], [
      - Factoriser, manipuler les polynômes, suites de polynômes, racines multiples.
    ],
    [TD 19 : Probabilités], [
      - Révisions dénombrement.
    ],
  ),
)

#semaine(numéro: 22, date: "10 au 16 mars 2025",
  séance(type: "cours", date: "Vendredi 14/03", durée: (1, 30),
    [Chapitre 19 : Probabilités], [
      - I.3 Une probabilité est déterminée par les probabilités des issues élémentaires.
      - II.1 Probabilités conditionnelles.
      - II.2 La formule des probabilités composées.
      - II.3 La formule des probabilités totales.
    ],
  ),
  séance(type: "cours", date: "Mercredi 12/03", durée: 2,
    [Chapitre 18 : Polynômes], [
      - II.2 Exemples de racines multiples, cas des polynômes de degré $3$.
    ],
    [Chapitre 19 : Probabilités], [
      - I.1 Univers, vocabulaire des évènements.
      - I.2 Définition d'une probabilité, exemple de la probabilité uniforme.
      - I.3 Propriétés d'une probabilité, systèmes complets d'évènements.
    ],
  ),
  séance(type: "TP", date: "Mardi 11/03", durée: 2, x2: true,
    [TP 19 : Graphes], [
      - Diverses représentations, graphes particuliers, chemins, pondération, parcours aléatoire.
    ],
  ),
  séance(type: "cours", date: "Mardi 11/03", durée: 2, spécial: true,
    [Chapitre 18 : Polynômes], [
      - II.1 Racines d'un polynôme, factorisation, polynômes scindés à racines simples, tout polynôme de degré impair admet au moins une racine.
      - II.2 Racines multiples, multiplicité, polynômes scindés, caractérisation des racines multiples par la dérivée.
    ],
  ),
  séance(type: "TD", date: "Lundi 11/03", durée: 3, x2: true,
    [TD 17 : Limites de suites], [
      - Suites $u_(n+1) = f(u_n)$.
      - Calculs de limites, équivalents.
    ],
    [TD 18 : Polynômes], [
      - Polynômes pairs et impairs, équations.
    ],
  ),
)

#semaine(numéro: 21, date: "3 au 9 mars 2025",
  séance(type: "DS", date: "Samedi 8/03", durée: 3,
    [DS 6], [],
  ),
  séance(type: "cours", date: "Vendredi 7/03", durée: (3, 30),
    [Chapitre 17 : Limites de suites], [
      - IV.2 Équivalents usuels, application au calcul de limites.
    ],
    [Chapitre 18 : Polynômes], [
      - I.1 Notion de polynôme, coefficients, degré.
      - I.2 Unicité des coefficients.
      - I.3 Opérations sur les polynômes, leur degré et leur coefficient dominant, somme, produit, dérivée, composition.
    ],
  ),
  séance(type: "cours", date: "Mercredi 5/03", durée: 2,
    [Chapitre 17 : Limites de suites], [
      - IV.1 Suites négligeables, notations petit $o$, comparaison $ln(n) = o(n^α)$, comparaison $n^α = o(q^n)$, comparaison $q^n = o(n!)$, application au calcul de limites.
      - IV.2 Suites équivalentes, manipulation des équivalents.
    ],
  ),
  séance(type: "TP", date: "Mardi 4/03", durée: 2, x2: true,
    [TP 18 : Dictionnaires], [
      - Dictionnaires et itération.
    ],
  ),
  séance(type: "TD", date: "Lundi 3/03", durée: 3, x2: true,
    [TD 15 : Géométrie], [
      - Équations de cercles.
    ],
    [TD 17 : Limites de suites], [
      - Sommes, suites implicites.
    ],
  ),
)

= Vacances d'hiver : 17 février au 2 mars 2025

#semaine(numéro: 20, date: "10 au 16 février 2025",
  séance(type: "cours", date: "Vendredi 14/02", durée: (3, 30),
    [Chapitre 17 : Limites de suites], [
      - II.5 Théorème de convergence monotone.
      - II.6 Théorème des suites adjacentes.
      - III.1 Limite de la somme de suites.
      - III.2 Limite du produit de suites.
      - III.3 Limite de l'inverse de suites.
      - III.4 Cas général, composition par une fonction, application aux suites $u_(n+1) = f(u_n)$.
    ],
    [DM 5 pour le 5/03], [],
  ),
  séance(type: "spécial", date: "Jeudi 13/02",
    [Match de basket Hoche-Ginette], [],
  ),
  séance(type: "cours", date: "Mercredi 12/02", durée: 2,
    [Chapitre 17 : Limites de suites], [
      - II.1 Unicité de la limite.
      - II.2 Suites extraites de rangs pairs et impaires.
      - II.3 Passage des inégalités à la limite.
      - II.4 Théorème d'encadrement des gendarmes.
    ],
  ),
  séance(type: "TP", date: "Mardi 11/02", durée: 2, x2: true,
    [TP 17 : Traitement de données en tables], [
      - Fichiers CSV et traitement.
    ],
  ),
  séance(type: "TD", date: "Lundi 10/02", durée: 3, x2: true,
    [Retour DM 4], [],
    [TD 15 : Géométrie], [
      - Situations usuelles, équations cartésiennes, paramétrages, intersections, projetés orthogonaux.
    ],
  ),
)

#semaine(numéro: 19, date: "3 au 9 février 2025",
  séance(type: "spécial", date: "Vendredi 7/02",
    [Rencontre avec les anciens étudiants], [],
  ),
  séance(type: "cours", date: "Vendredi 7/02", durée: 2,
    [Chapitre 15 : Géométrie], [
      - III Vecteur normal, projeté orthogonal, équations de cercles et de sphères.
    ],
    [Chapitre 16 : Statistiques], [],
    [Chapitre 17 : Limites de suites], [
      - I.1 Définition de convergence, de divergence vers $±oo$.
      - I.2 Diverses remarques sur la définition, une suite convergente est bornée.
    ],
  ),
  séance(type: "cours", date: "Mercredi 5/02", durée: 2,
    [Chapitre 15 : Géométrie], [
      - II Équation cartésienne de droites, plans de l'espace, droites de l'espace, convertir entre équation cartésienne et paramétrage.
      - III Produit scalaire de vecteurs, norme, distance entre deux points, inégalité de Cauchy-Schwarz, inégalité de Minkowski, angle.
    ],
  ),
  séance(type: "TD", date: "Mardi 4/02", durée: 3, x2: true, spécial: true,
    [TD 14 : Équations différentielles], [
      - Méthodes avancées.
    ],
  ),
  séance(type: "TD", date: "Lundi 3/02", durée: 3, x2: true,
    [TD 14 : Équations différentielles], [
      - Résoudre des équations différentielles d'ordre 1 ou 2, chercher une solution particulière sous forme donnée, méthode de variation de la constante.
    ],
  ),
)

#semaine(numéro: 18, date: "27 janvier au 2 février 2025",
  séance(type: "spécial", date: "Samedi 1/02",
    [Journées portes ouvertes], [],
  ),
  séance(type: "cours", date: "Vendredi 31/01", durée: (3, 30),
    [Retour DS 5], [],
    [Chapitre 14 : Équations différentielles], [
      - III.4 Cas $Δ < 0$, fonction exponentielle complexe.
    ],
    [Chapitre 15 : Géométrie], [
      - I Espaces vectoriels de dimension 2 et 3, notion de vecteurs colinéaires, coplanaires, matrice d'une famille de vecteurs, base.
      - II Espaces affines, équation de droite paramétrée.
    ],
  ),
  séance(type: "cours", date: "Mercredi 29/01", durée: 2,
    [Chapitre 14 : Équations différentielles], [
      - II.3 Trouver une solution particulière sous forme donnée, méthode de variation de la constante.
      - II.4 Conditions initiales, théorème de Cauchy-Lipschitz.
      - III.1 Équations différentielles linéaires d'ordre 2, à coefficients constants, homogènes ou avec second membre, principe de superposition, linéarité, théorème de Cauchy-Lipschitz, équation caractéristique.
      - III.2 Cas $Δ > 0$.
      - III.3 Cas $Δ = 0$.
    ],
  ),
  séance(type: "TP", date: "Mardi 28/01", durée: (1, 30), x2: true,
    [TP 15 : Matrices], [
      - Représenter des matrices en Python avec des listes de listes.
      - Opérations usuelles, pivot de Gauss.
    ],
  ),
  séance(type: "TD", date: "Lundi 27/01", durée: 3, x2: true,
    [TD 13 : Matrices], [
      - Échelonner et inverser des matrices.
    ],
  ),
)

#semaine(numéro: 17, date: "20 au 26 janvier 2025",
  séance(type: "cours", date: "Vendredi 24/01", durée: (3, 30),
    [Chapitre 13 : Matrices], [
      - III.4 Le cas des matrices de taille $2$, déterminant.
      - IV La transposée, propriétés, transposée d'un produit, matrices symétriques et anti-symétriques.
    ],
    [Chapitre 14 : Équations différentielles], [
      - I Exemples introductifs.
      - II.1 Équations différentielles linéaires d'ordre $1$ à coefficients constants.
      - II.2 Équations à coefficients non-constants.
      - II.3 Équations avec second membre, principe de superposition.
    ]
  ),
  séance(type: "cours", date: "Mercredi 22/01", durée: 2,
    [Chapitre 13 : Matrices], [
      - III.1 Interprétation matricielle des systèmes linéaires, notion de matrice inversible.
      - III.2 Matrices inversibles, unicité de l'inverse, propriétés algébriques.
      - III.3 Opérations élémentaires sur les matrices, matrices échelonnées, rang.
    ],
  ),
  séance(type: "TP", date: "Mardi 21/01", durée: 2, x2: true,
    [TP 16 : Manipulation d'images], [
      - Charger et manipuler des images avec `numpy`.
      - Forme, luminosité, seuillage, contraste, flou, contours.
    ],
  ),
  séance(type: "spécial", date: "Lundi 20/01",
    [Conférence : Ours, loup, lynx], [],
  ),
  séance(type: "spécial", date: "Lundi 20/01",
    [Conseil de classe du premier semestre], [],
  ),
  séance(type: "TD", date: "Lundi 20/01", durée: 3, x2: true,
    [TD 12 : Calculs de dérivées, primitives, intégrales], [
      - Changement de variables, méthodes avancées.
    ],
    [TD 13 : Matrices], [
      - Puissances de matrices.
    ],
  ),
)

#semaine(numéro: 16, date: "13 au 19 janvier 2025",
  séance(type: "DS", date: "Samedi 18/01", durée: 3,
    [DS 5], [],
  ),
  séance(type: "spécial", date: "Vendredi 17/01",
    [Visite AgroParisTech], [],
  ),
  séance(type: "cours", date: "Vendredi 17/01", durée: (3, 30),
    [Chapitre 13 : Matrices], [
      - II.2 Distributivité du produit de matrices, matrice identité.
      - II.3 Matrices diagonales, matrices scalaires, matrices triangulaires.
      - II.4 Puissances de matrices, méthode par récurrence, matrices nilpotentes.
      - II.5 La formule du binôme de Newton pour les matrices.
    ],
    [Correction DM 4], [],
  ),
  séance(type: "cours", date: "Mercredi 15/01", durée: 2,
    [Chapitre 13 : Matrices], [
      - I.1 Notion de matrice, matrices lignes, matrices colonnes, matrices carrées, matrice nulle.
      - I.2 Somme de matrices, produit par une constante, leurs propriétés.
      - II.1 Produit d'une matrice ligne par une matrice colonne.
      - II.2 Produit de matrices, non-commutativité, non-intégrité, associativité.
    ],
  ),
  séance(type: "TP", date: "Mardi 14/01", durée: 2, x2: true,
    [TP 14 : Numpy et Matplotlib], [
      - Manipulations générales des bibliothèques.
      - Tracer des graphes de fonctions, représenter des suites, applications à l'analyse.
    ],
  ),
  séance(type: "TD", date: "Lundi 13/01", durée: 3, x2: true,
    [TD 12 : Calculs de dérivées, primitives, intégrales], [
      - Applications de la dérivation, dérivées partielles, primitives, intégrales, intégration par parties.
    ],
  ),
)

#semaine(numéro: 15, date: "6 au 12 janvier 2025",
  séance(type: "cours", date: "Vendredi 10/01", durée: 4,
    [Chapitre 12 : Calculs de dérivées, primitives, intégrales], [
      - IV.2 Exemples de calculs d'intégrales.
      - IV.3 Intégration par parties, exemples, calculs de primitives.
      - IV.4 Changement de variable, exemples.
    ],
    [Soutien], [Intégrales, intégration par parties, changement de variable.],
  ),
  séance(type: "cours", date: "Mercredi 8/01", durée: 2,
    [Chapitre 12 : Calculs de dérivées, primitives, intégrales], [
      - III.1 Quelques notions sur les fonctions à plusieurs variables, domaine de définition, fonctions partielles.
      - III.2 Dérivées partielles.
      - IV.1 Notion d'intégrale, propriétés élémentaires, linéarité, relation de Chasles, positivité, croissance, stricte positivité.
      - IV.2 Le théorème fondamental du calcul intégral.
    ],
  ),
  séance(type: "TP", date: "Mardi 7/01", durée: 2, x2: true,
    [TP 13 : Révisions et consolidation 2], [
      - Récursivité, dénombrement.
    ],
  ),
  séance(type: "TD", date: "Lundi 6/01", durée: 3, x2: true,
    [Retour DM 3], [],
    [TD 11 : Dénombrement], [
      - Situations algébriques.
    ],
    [TD 12 : Calculs de dérivées, primitives, intégrales], [
      - Cahier de calcul 10 (dérivation), 11 (primitives).
      - Applications de la dérivation.
    ],
    [DM 4 pour le 17/01], [],
  ),
)

= Vacances du nouvel an : 24 décembre 2024 au 5 janvier 2025

#semaine(numéro: 14, date: "16 au 22 décembre",
  séance(type: "cours", date: "Vendredi 20/12", durée: (3, 30),
    [Retour DS 4], [],
    [Chapitre 12 : Calculs de dérivées, primitives, intégrales], [
      - I.4 Dérivée de la fonction réciproque, application à la fonction arctangente et aux fonctions trigonométriques réciproques.
      - II.1 Rappels sur les primitives, unicité à une constante près.
      - II.2 Méthode de calculs de primitives, primitives usuelles.
    ],
  ),
  séance(type: "cours", date: "Mercredi 18/12", durée: 2,
    [Chapitre 12 : Calculs de dérivées, primitives, intégrales], [
      - I.1 Taux de variation, nombre dérivé, fonction dérivée.
      - I.2 Calculs de dérivées usuelles à partir de la définition, $x^2$, $x^n$, $1/x$, $sqrt(x)$.
      - I.3 Opérations usuelles sur les dérivées, somme, produit, composition, applications de la composition.
    ],
  ),
  séance(type: "TP", date: "Mardi 17/12", durée: 2, x2: true,
    [TP 12 : Algorithmes récursifs], [
      - Tracer des fractales avec le module `turtle`.
    ],
  ),
  séance(type: "TD", date: "Lundi 16/12", durée: 3, x2: true,
    [TD 11 : Dénombrement], [
      - Dénombrer dans de nombreuses situations concrètes.
    ],
  ),
)

#semaine(numéro: 13, date: "9 au 15 décembre",
  séance(type: "cours", date: "Vendredi 12/12", durée: (3, 30),
    [Chapitre 11 : Dénombrement], [
      - II.3 Cardinal de l'ensemble des applications de $E$ dans $F$.
      - II.4 Listes sans répétitions, nombre d'arrangements, permutations, divers exemples de situations.
      - II.5 Parties de $E$ à $p$ éléments, diverses situations, cardinal de l'ensemble de toutes les parties de $E$, bijection entre parties de $E$ et fonctions indicatrices.
      - III Interprétation combinatoire des formules sur les coefficients binomiaux, formule du pion, binôme de Newton.
      - IV D'autres situations, anagrammes.
    ],
  ),
  séance(type: "cours", date: "Mercredi 11/12", durée: 2,
    [Chapitre 11 : Dénombrement], [
      - I.1 Ensembles finis, définition via une bijection, cardinal, complémentaire, inclusion, union.
      - I.2 Applications injectives, surjectives, bijectives entre ensembles finis.
      - II.1 Cardinal d'une union disjointe, partition.
      - II.2 Cardinal d'un produit cartésien, cardinal de l'ensemble des $p$-listes d'éléments de $E$, exemples de situations de produit cartésien ou de listes, compter en binaire.
    ],
  ),
  séance(type: "TP", date: "Mardi 10/12", durée: 2, x2: true,
    [TP 11 : Dichotomie], [
      - Jeu du plus grand ou plus petit, recherche de solutions d'équations, recherche dans une liste.
    ],
  ),
  séance(type: "TD", date: "Lundi 9/12", durée: 3, x2: true,
    [TD 10 : Systèmes linéaires], [
      - Échelonner et résoudre des systèmes linéaires, systèmes à paramètres.
    ],
  ),
)

#semaine(numéro: 12, date: "2 au 8 décembre",
  séance(type: "DS", date: "Samedi 7/12", durée: 3,
    [DS 4], [],
  ),
  séance(type: "cours", date: "Vendredi 6/12", durée: (3, 30),
    [Chapitre 10 : Systèmes linéaires], [
      - II.3 Exemples d'application du pivot de Gauss, commentaires sur la forme échelonnée.
      - II.4 Le rang, systèmes de Cramer, systèmes de rang maximal.
      - III D'autres exemples, application aux polynômes, systèmes à paramètres, équilibrer une réaction chimique.
    ],
    [TD 9 : Étude de fonctions], [
      - Inégalités, puissances réelles.
    ],
  ),
  séance(type: "cours", date: "Mercredi 4/12", durée: 2,
    [Chapitre 10 : Systèmes linéaires], [
      - I Exemples, diverses situations à 3 ou 4 inconnues.
      - II.1 Définitions, système linéaire, compatibilité, homogénéité.
      - II.2 Les trois opérations élémentaires.
      - II.3 Pivot de Gauss, définition d'un système échelonné, équations principales et conditions de compatibilité, inconnues principales et inconnues libres.
    ],
  ),
  séance(type: "TP", date: "Mardi 3/12", durée: 2, x2: true,
    [TP 10 : Récursivité], [
      - Fonctions récursives, nouveaux phénomènes.
    ],
  ),
  séance(type: "TD", date: "Lundi 2/12", durée: 3, x2: true,
    [TD 8 : Applications], [
      - Étudier la bijectivité et donner la bijection réciproque.
    ],
    [TD 9 : Étude de fonctions], [
      - Domaine de définition, inégalités.
    ],
  ),
)

#semaine(numéro: 11, date: "25 novembre au 1 décembre",
  séance(type: "spécial", date: "Samedi 30/11",
    [Forum des grandes écoles], [],
  ),
  séance(type: "cours", date: "Vendredi 29/11", durée: 4,
    [Retour DS 3], [],
    [Chapitre 9 : Étude de fonctions], [
      - II.6 Fonction réciproque, sens de variation, parité.
      - III.1 Représentation graphique, effet des opérations.
      - III.2 Symétries du graphe.
      - III.3 Tangentes, asymptotes.
      - IV.1 Catalogue des fonctions usuelles, fonctions puissances $x |-> x^n$ avec $n in NN$, puis avec $n in ZZ$, fonctions racines.
      - IV.2 Fonctions logarithme et exponentielle.
      - IV.3 Puissances réelles. Fonction puissance $x |-> x^α$ avec $α in RR$, exponentielle de base quelconque $x |-> a^x$ avec $a in lr(bracket.r 0, +oo bracket.l)$.
      - IV.4 Fonctions trigonométriques et leur réciproque.
    ],
    [DM 3 pour le 13/12], [],
    [Soutien], [Exponentielle et logarithme, dérivation, correction du DS 3.],
  ),
  séance(type: "cours", date: "Mercredi 27/11", durée: 2,
    [Chapitre 9 : Étude de fonctions], [
      - I Opérations sur les fonctions, domaine de définition, déterminer le domaine de définition.
      - II.1 Propriétés de croissance, composition.
      - II.2 Propriétés de majorations, d'extrema.
      - II.3 Rappels sur la dérivée et le sens de variation. Application à démontrer des inégalités.
      - II.4 Fonctions paires et impaires, étudier la parité.
      - II.5 Fonctions périodiques, plus petite période.
    ],
  ),
  séance(type: "TP", date: "Mardi 26/11", durée: 2, x2: true,
    [TP 9 : Recherche dans un texte], [
      - Recherche de mot ou de séquence ADN.
      - L'algorithme de Knuth-Morris-Pratt.
    ],
  ),
  séance(type: "TD", date: "Lundi 25/11", durée: 3, x2: true,
    [TD 8 : Applications], [
      - Étudier l'injectivité et la surjectivité, composer des applications, utiliser un tableau de variations.
    ],
  ),
)

#semaine(numéro: 10, date: "18 au 24 novembre",
  séance(type: "cours", date: "Vendredi 22/11", durée: 4,
    [Chapitre 8 : Applications], [
      - II.2 Surjectivité, exemples.
      - II.3 Bijectivité, application réciproque, exemples.
      - II.4 Point de vue de la composition, inverse pour la composition, unicité, composition de bijections.
      - III Cas des fonctions réelles, une fonction monotone est injective, théorème des valeurs intermédiaires, l'image d'un intervalle par une fonction continue est un intervalle, théorème de la bijection, application aux fonctions trigonométriques réciproques.
    ],
    [Soutien], [Exponentielle et logarithme, dérivation.],
  ),
  séance(type: "cours", date: "Mercredi 20/11", durée: 2,
    [Chapitre 8 : Applications], [
      - I.2 Lois de Morgan via les applications caractéristiques.
      - I.3 Opération de composition, non-commutativité, élément neutre, associativité.
      - I.4 Images directes et réciproques, utilisation des tableaux de variation, utilisation des systèmes linéaires, composition.
      - II.1 Injectivité, exemples.
    ],
  ),
  séance(type: "TP", date: "Mardi 19/11", durée: 2, x2: true,
    [TP 8 : Tri], [
      - Rappels sur les algorithmes sur les listes.
      - Les algorithmes de tri.
    ],
  ),
  séance(type: "spécial", date: "Lundi 18/11",
    [Conférence : Le carbone dans les sols], [],
  ),
  séance(type: "TD", date: "Lundi 18/11", durée: 3, x2: true,
    [TD 7 : Sommes et produits], [
      - Calculs de sommes, de sommes doubles, binôme de Newton.
    ],
  ),
)

#semaine(numéro: 9, date: "11 au 17 novembre",
  séance(type: "DS", date: "Samedi 16/11", durée: 3,
    [DS 3], [],
  ),
  séance(type: "cours", date: "Vendredi 15/11", durée: (3, 30),
    [Chapitre 7 : Sommes et produits], [
      - II.3 Exemples de calculs avec la formule du binôme de Newton.
    ],
    [Retour DM 2], [],
    [TD 7 : Sommes et produits], [
      - Calculs de sommes et de sommes doubles.
    ],
    [Chapitre 8 : Applications], [
      - I.1 Notion d'application, image, antécédent, ensembles de départ et d'arrivée, graphe, égalité d'applications, notion de fonction, domaine de définition, graphe.
      - I.2 L'application identité, restriction d'applications, prolongements, application caractéristique d'une partie.
    ],
  ),
  séance(type: "cours", date: "Mercredi 13/11", durée: 2,
    [Chapitre 7 : Sommes et produits], [
      - II.2 Coefficients binomiaux, formule de Pascal, triangle de Pascal.
      - II.3 La formule du binôme de Newton, exemples de calculs.
    ],
  ),
  séance(type: "TD", date: "Mardi 12/11", durée: 2, x2: true, spécial: true,
    [TD 6 : Suites], [
      - Suites récurrentes non-linéaires.
    ],
    [TD 7 : Sommes et produits], [
      - Renversement de sommes, méthode de Gauss.
    ],
  ),
)

#semaine(numéro: 8, date: "4 au 10 novembre",
  séance(type: "cours", date: "Vendredi 8/11", durée: 4,
    [Chapitre 7 : Sommes et produits], [
      - I.3 Notion de somme de famille indexée par un ensemble, exemple des termes d'indice pair et impair.
      - I.4 Décalage d'indice, application aux sommes téléscopiques, formule $a^n - b^n$.
      - I.5 Sommes doubles, interversion de la somme, carré ou triangle d'indices.
      - II.1 Le symbole $product$ et ses propriétés.
      - II.2 Factoriel, premiers exemples de calculs de produits.
      - III Calculs de sommes en Python.
    ],
    [Soutien], [Trigonométrie, nombres complexes, logarithmes, correction du DS 2.],
  ),
  séance(type: "spécial", date: "Jeudi 7/11",
    [Pré-conseil de classe], [],
  ),
  séance(type: "cours", date: "Mercredi 6/11", durée: 2,
    [Chapitre 7 : Sommes et produits], [
      - I.1 Le symbole $sum$ et ses propriétés, séparation de la somme, linéarité, cas des sommes complexes, inégalité triangulaire.
      - I.2 Sommes à connaitre $sum_(k=1)^n k$, $sum_(k=1)^n k^2$, $sum_(k=0)^n q^k$, exemples de calculs de sommes.
    ],
  ),
  séance(type: "TP", date: "Mardi 5/11", durée: 2, x2: true,
    [TP 7 : Révisions et consolidation~1], [
      - Diverses situations, conditions, boucles, listes.
    ],
  ),
  séance(type: "TD", date: "Lundi 4/11", durée: 3, x2: true,
    [TD 6 : Suites], [
      - Suites récurrences linéaires d'ordre 1 et 2.
    ],
  ),
)

= Vacances d'automne : 21 octobre au 3 novembre

#semaine(numéro: 7, date: "14 au 20 octobre",
  séance(type: "cours", date: "Vendredi 18/10", durée: (3, 30),
    [Chapitre 6 : Suites], [
      - III.1 Équation caractéristique, principe de linéarité.
      - III.2 Cas $Δ > 0$.
      - III.3 Cas $Δ < 0$.
      - III.4 Cas $Δ = 0$.
      - IV Calcul de termes de suites, et de listes de termes de suites, en Python.
    ],
    [DM 2 pour le 6/11], [],
  ),
  séance(type: "spécial", date: "Jeudi 17/10",
    [Entretiens individuels], [],
  ),
  séance(type: "cours", date: "Mercredi 16/10", durée: 2,
    [Chapitre 6 : Suites], [
      - I Notions générales, ensemble des termes d'une suite, croissance, majorations, suites bornées, diverses situations et contre-exemples, propriétés vraies à partir d'un certain rang.
      - II.1 Suites arithmétiques.
      - II.2 Suites géométriques.
      - II.3 Suites arithmético-géométriques, recherche du point fixe, convergence vers le point fixe.
      - III Suites récurrentes d'ordre 2, exemple de Fibonacci.
    ],
  ),
  séance(type: "TP", date: "Mardi 15/10", durée: 2, x2: true,
    [TP 6 : Algorithmes sur les listes], [
      - Diverses situations : compter, sommer, tester une propriété, chercher.
    ],
  ),
  séance(type: "TD", date: "Lundi 14/10", durée: 3, x2: true,
    [TD 5 : Nombres complexes], [
      - Équations, forme exponentielle.
    ],
  ),
)

#semaine(numéro: 6, date: "7 au 13 octobre",
  séance(type: "DS", date: "Samedi 12/10", durée: 3,
    [DS 2], [],
  ),
  séance(type: "cours", date: "Vendredi 11/10", durée: 4,
    [Chapitre 5 : Nombres complexes], [
      - III.1 Introduction de la notation $e^(i θ)$, propriétés élémentaires, interprétation géométrique.
      - III.2 Nombres complexes sous forme exponentielle, conséquences sur le calcul, application au calcul de puissances, application aux racines carrées d'un nombre complexe.
      - III.3 Applications à la trigonométrie, formules d'Euler et de Moivre, applications pour linéariser ou pour développer.
    ],
    [Soutien], [
      - Nombres complexes, trigonométrie.
    ],
  ),
  séance(type: "cours", date: "Mercredi 9/10", durée: 2,
    [Chapitre 5 : Nombres complexes], [
      - II.5 Propriétés algébriques de la conjugaison.
      - II.6 Le module, interprétation géométrique, propriétés algébriques, inégalité triangulaire.
      - II.7 Application aux équations du second degré, solutions complexes dans le cas $Δ < 0$, relation entre coefficients et sommes et produits des racines.
    ],
  ),
  séance(type: "TP", date: "Mardi 8/10", durée: 2, x2: true,
    [TP 5 : Listes], [
      - Introduction, opérations, itérer sur une liste.
      - Créer une liste, avec une liste de zéros, ou par `append` successifs, listes en compréhension.
    ],
  ),
  séance(type: "TD", date: "Lundi 7/10", durée: 3, x2: true,
    [Retour DM 1], [],
    [TD 4 : Trigonométrie], [
      - Identités sur les fonctions trigonométriques réciproques, linéarisation.
    ],
    [TD 5 : Nombres complexes], [
      - Quelques calculs.
    ],
  ),
)

#semaine(numéro: 5, date: "30 septembre au 6 octobre",
  séance(type: "cours", date: "Vendredi 4/10", durée: 4,
    [Retour DS 1], [],
    [Chapitre 5 : Nombres complexes], [
      - II.3 Conséquences, écriture d'un nombre complexe sous forme algébrique, parties réelles et imaginaires, nombres réels et nombres imaginaires purs, identités remarquables, équation $z^2 = c$ où $c ∈ RR$, calculs sur les fractions, calculs sur les puissances, pas de bonne notion d'ordre.
      - II.4 Représentation géométrique, plan complexe, affixe, interprétation de quelques opérations.
      - II.5 Conjugaison complexe, expression des parties réelles et imaginaires, critère pour qu'un nombre complexe soit réel, pour qu'il soit imaginaire pur.
    ],
    [Soutien], [
      - Nombres complexes, trigonométrie, correction du DS 1.
    ],
  ),
  séance(type: "cours", date: "Mercredi 2/10", durée: 2,
    [Chapitre 5 : Nombres complexes], [
      - I Introduction « naïve », manipulations de nombres complexes sous forme algébrique, unicité des parties réelles et imaginaires.
      - II.1 Une construction de $CC$ comme $RR^2$ avec une somme et un produit.
      - II.2 Propriétés algébriques de ces opérations, associativité de la multiplication, distributivité.
    ],
  ),
  séance(type: "TP", date: "Mardi 1/10", durée: 2, x2: true,
    [TP 4 : Boucles `for`], [
      - Boucles `for` simples, application au calcul de suites et de sommes.
      - Boucles doubles.
    ],
  ),
  séance(type: "TD", date: "Lundi 30/09", durée: 3, x2: true,
    [TD 3 : Nombres réels], [
      - Maximum dans $ZZ$, partie entière et approximation décimale.
    ],
    [TD 4 : Trigonométrie], [
      - Application des formules, équations et inéquations.
    ],
  ),
)

#semaine(numéro: 4, date: "23 au 29 septembre",
  séance(type: "spécial", date: "Samedi 28/09",
    [Pot des intégrés], [],
  ),
  séance(type: "cours", date: "Vendredi 27/09", durée: (3, 30),
    [Chapitre 4 : Trigonométrie], [
      - III.1 Équations trigonométriques, donner toutes les solutions, inéquations.
      - III.2 Les fonctions trigonométriques réciproques $arcsin$, $arccos$, $arctan$.
      - III.3 Quelques identités, exemple de $arccos(-x) = π - arccos(x)$.
      - III.4 Applications, résolution d'équations trigonométriques, coordonnées polaires, simplifier $A cos(θ) + B sin(θ)$ en #box[$r cos(θ + φ)$] et applications.
    ],
  ),
  séance(type: "cours", date: "Mercredi 25/09", durée: 2,
    [Chapitre 4 : Trigonométrie], [
      - I.1 Repère orthonormé direct, cercle trigonométrique, angles en radian, fonctions trigonométriques $sin$, $cos$, $tan$.
      - I.2 Valeurs remarquables des fonctions trigonométriques.
      - I.3 Les formules de symétries.
      - II Les formules d'addition, de duplication, démonstration par rotation du repère orthonormé.
    ],
  ),
  séance(type: "TP", date: "Mardi 24/09", durée: 2, x2: true,
    [TP 3 : Fonctions], [
      - Notion de fonction, instruction `return`.
      - Modules, aide interactive, instruction `assert`.
    ],
  ),
  séance(type: "TD", date: "Lundi 23/09", durée: 3, x2: true,
    [TD 3 : Nombres réels], [
      - Équations et inéquations, inégalités et racines carrées, bornes supérieures, parties entières.
    ],
  ),
)

#semaine(numéro: 3, date: "16 au 22 septembre",
  séance(type: "DS", date: "Samedi 21/09", durée: 3,
    [DS 1], [],
  ),
  séance(type: "cours", date: "Vendredi 20/09", durée: (3, 30),
    [Chapitre 3 : Nombres réels], [
      - II.3 Existence de borne supérieure dans $RR$.
      - II.4 Cas des intervalles, propriété de convexité, application à la classification des intervalles.
      - III La fonction partie entière, existence et unicité, représentation graphique, parties entières de racines carrées, application au nombre de chiffres dans l'écriture décimale.
      - IV Rappel des règles de calcul sur les puissances, racines carrées, racines cubiques, puissances négatives et fractionnaires, quantités conjuguées des racines.
    ],
  ),
  séance(type: "cours", date: "Mercredi 18/09", durée: 2,
    [Chapitre 3 : Nombres réels], [
      - II.1 Parties de $RR$ majorées, minorées, bornées, équivalence entre « majoré et minoré » et « majoré en valeur absolue », exemples de majorations.
      - II.2 Maximum, minimum, unicité du maximum, existence pour les parties de $ZZ$.
      - II.3 Bornes supérieures et bornes inférieures, exemples.
    ],
  ),
  séance(type: "spécial", date: "Mercredi 18/09",
    [Photo de classe], [],
  ),
  séance(type: "TP", date: "Mardi 17/09", durée: 2, x2: true,
    [TP 2 : Conditions et boucles], [
      - Conditions `if`, `else`, `elif`.
      - Boucles `while`.
    ],
  ),
  séance(type: "TD", date: "Lundi 16/09", durée: 3, x2: true,
    [TD 2 : Méthodes de démonstration], [
      - Égalité d'ensembles, valeurs absolues, récurrences.
      - Révisions calcul.
    ],
  ),
)

#semaine(numéro: 2, date: "9 au 15 septembre",
  séance(type: "cours", date: "Vendredi 13/09", durée: (3, 30),
    [Chapitre 2 : Méthodes de démonstration], [
      - V Unicité, il existe au plus.
      - VI Récurrence simple, récurrence double.
    ],
    [Chapitre 3 : Nombres réels], [
      - I.1 Propriétés de l'addition et de la multiplication, commutativité, associativité, élément neutre, opposé, inverse, distributivité, identités remarquables, intégrité.
      - I.4 Propriétés de la relation d'ordre, réflexivité, anti-symétrie, transitivité, ordre total, compatibilité avec les opérations.
      - I.6 La valeur absolue, positivité stricte, multiplicativité, inégalité triangulaire (trois versions).
    ],
  ),
  séance(type: "spécial", date: "Jeudi 12/09",
    [Sortie en vallée de Chevreuse], [],
  ),
  séance(type: "cours", date: "Mercredi 11/09", durée: 2,
    [Chapitre 2 : Méthodes de démonstration], [
      - III Inclusions et égalités d'ensembles.
      - IV Démonstration d'un $∀$, méthode directe, disjonction de cas.
      - V Démonstration d'un $∃$, méthode directe, le théorème des valeurs intermédiaires, principe des tiroirs, analyse-synthèse.
    ],
  ),
  séance(type: "TP", date: "Mardi 10/09", durée: 2, x2: true,
    [TP 1 : Prise en main], [
      - Mode interactif, variables, types entiers, flottants, chaines de caractères, booléens.
      - Mode script, `print` et `input`.
    ],
  ),
  séance(type: "TD", date: "Lundi 9/09", durée: 3, x2: true,
    [TD 1 : Logique], [
      - Assertions, logique, tables de vérité, ensembles, quantificateurs.
      - Révisions calcul.
    ],
  ),
)

#semaine(numéro: 1, date: "2 au 8 septembre",
  séance(type: "cours", date: "Vendredi 6/09", durée: (3, 30),
    [Chapitre 1 : Logique], [
      - II.3 Complémentaire, propriétés de l'union et de l'intersection, commutativité, associativité, loi de Morgan, distributivité.
      - II.4 Produit cartésien, listes.
      - III.1 Quantificateurs pour tout, il existe, et leur négation.
      - III.2 Assertions avec plusieurs quantificateurs, problème de l'ordre des quantificateurs.
    ],
    [Chapitre 2 : Méthodes de démonstration], [
      - I Démonstration d'une implication directe, utilisation de la contraposée, raisonnement par l'absurde.
      - II Raisonnement par équivalences, raisonnement par implication et réciproque.
    ],
    [DM 1 pour le 20/09], []
  ),
  séance(type: "cours", date: "Mercredi 4/09", durée: 2,
    [Chapitre 1 : Logique], [
      - I.4 Implication, négation, réciproque, équivalence, condition nécessaire et suffisante, contraposée.
      - II.1 Ensembles, exemples de constructions.
      - II.2 Inclusion, réflexivité, anti-symétrie, transitivité, ensemble des parties.
      - II.3 Union, intersection, différence.
    ],
  ),
  séance(type: "cours", date: "Mardi 3/09", durée: 2, spécial: true,
    [Présentation générale], [],
    [Chapitre 1 : Logique], [
      - I.1 Assertions, fermées ou avec des variables libres.
      - I.2 Constructions d'assertions avec et, ou, non, tables de vérité.
      - I.3 Propriétés : commutativité, associativité, lois de Morgan, distributivité.
    ],
  ),
  séance(type: "spécial", date: "Mardi 3/09", durée: 2,
    [Accueil des élèves], [
      - Journée de rentrée.
      - Accueil par les trois professeurs de la classe et formalités.
    ],
  ),
)
